unit UnitMainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus, ComCtrls, ExtCtrls, Buttons, ActnList,
  GsvObjectInspectorTypes, GsvObjectInspectorGrid,
  UnitDemoObj, XPMan;

type
  TForm1 = class(TForm)
    PanelLeft:                TPanel;
    SplitterVert:             TSplitter;
    PanelRight:               TPanel;
    PanelTop:                 TPanel;
    StatusBar:                TStatusBar;

    LabelObject:              TLabel;

    MainMenu:                 TMainMenu;
    mnuInspector:             TMenuItem;
    mnuInspectorClear:        TMenuItem;
    mnuInspectorHideReadOnly: TMenuItem;
    mnuInspectorExpandAll:    TMenuItem;
    mnuInspectorCollapseAll:  TMenuItem;
    mnuInspectorSep1:         TMenuItem;
    mnuExit:                  TMenuItem;

    PanelLabel1:              TPanel;
    Label1:                   TLabel;
    CheckBoxAutoUpdate:       TCheckBox;
    TimerInspector:           TTimer;
    TimerDemo:                TTimer;

    Button1:                  TButton;
    Button2:                  TButton;
    ButtonRect:               TButton;
    ButtonDemo:               TButton;
    XPManifest1: TXPManifest;
    Button3: TButton;
    Button4: TButton;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);

    procedure mnuInspectorClearClick(Sender: TObject);
    procedure mnuInspectorHideReadOnlyClick(Sender: TObject);
    procedure mnuInspectorExpandAllClick(Sender: TObject);
    procedure mnuInspectorCollapseAllClick(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);

    procedure InspectObject(Sender: TObject);

    procedure OnEnumProperties(Sender: TObject; Index: Integer;
              out Info: PGsvObjectInspectorPropertyInfo);
    procedure OnGetStringValue(Sender: TObject;
              Info: PGsvObjectInspectorPropertyInfo; out Value: String);
    procedure OnSetStringValue(Sender: TObject;
              Info: PGsvObjectInspectorPropertyInfo; const Value: String);
    procedure OnGetIntegerValue(Sender: TObject;
              Info: PGsvObjectInspectorPropertyInfo; out Value: LongInt);
    procedure OnSetIntegerValue(Sender: TObject;
              Info: PGsvObjectInspectorPropertyInfo; const Value: LongInt);
    procedure OnFillList(Sender: TObject;
              Info: PGsvObjectInspectorPropertyInfo; List: TStrings);
    procedure OnShowDialog(Inspector: TComponent;
              Info: PGsvObjectInspectorPropertyInfo; const EditRect: TRect);
    procedure OnHelp(Sender: TObject;
              Info: PGsvObjectInspectorPropertyInfo);
    procedure OnHint(Sender: TObject;
              Info: PGsvObjectInspectorPropertyInfo);
    procedure OnGetCaption(Sender: TObject;
              Info: PGsvObjectInspectorPropertyInfo; var aCaption: string);

    procedure ButtonRectClick(Sender: TObject);
    procedure TimerInspectorTimer(Sender: TObject);
    procedure TimerDemoTimer(Sender: TObject);
    procedure CheckBoxAutoUpdateClick(Sender: TObject);
    procedure ButtonDemoClick(Sender: TObject);

  private
    ObjectInspector: TGsvObjectInspectorGrid;
    Proxy:           TObject;
    FRect:           TRect;
    DemoObject:      TDemoObject;

    procedure StatusClear;
    procedure StatusMessage(const S: String);
    procedure ClearInspector;
  end;

var
  Form1: TForm1;

implementation

uses
  UnitInfo;

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  ObjectManager                     := TGsvObjectInspectorObjectInfo.Create;
  ObjectInspector                   := TGsvObjectInspectorGrid.Create(Self);
  ObjectInspector.Parent            := PanelLeft;
  ObjectInspector.Align             := alClient;
  ObjectInspector.Visible           := True;
  ObjectInspector.RowHeight         := 18;
  ObjectInspector.DividerPosition   := 150;
  ObjectInspector.TabStop           := True;
  ObjectInspector.FolderFontColor   := clMaroon;
  ObjectInspector.FolderFontStyle   := [fsBold];
  ObjectInspector.DropDownCount     := 5;
  ObjectInspector.LongTextHintTime  := 3000;
  ObjectInspector.LongEditHintTime  := 3000;
  ObjectInspector.HideReadOnly      := mnuInspectorHideReadOnly.Checked;
  ObjectInspector.OnEnumProperties  := OnEnumProperties;
  ObjectInspector.OnGetStringValue  := OnGetStringValue;
  ObjectInspector.OnSetStringValue  := OnSetStringValue;
  ObjectInspector.OnGetIntegerValue := OnGetIntegerValue;
  ObjectInspector.OnSetIntegerValue := OnSetIntegerValue;
  ObjectInspector.OnFillList        := OnFillList;
  ObjectInspector.OnShowDialog      := OnShowDialog;
  ObjectInspector.OnHelp            := OnHelp;
  ObjectInspector.OnHint            := OnHint;
  ObjectInspector.OnGetCaption      := OnGetCaption;
  DemoObject                        := TDemoObject.Create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  DemoObject.Free;
end;

procedure TForm1.mnuInspectorClearClick(Sender: TObject);
begin
  ClearInspector;
end;

procedure TForm1.mnuInspectorHideReadOnlyClick(Sender: TObject);
begin
  mnuInspectorHideReadOnly.Checked := not mnuInspectorHideReadOnly.Checked;
  ObjectInspector.HideReadOnly := mnuInspectorHideReadOnly.Checked;
end;

procedure TForm1.mnuInspectorExpandAllClick(Sender: TObject);
begin
  ObjectInspector.ExpandAll;
end;

procedure TForm1.mnuInspectorCollapseAllClick(Sender: TObject);
begin
  ObjectInspector.CollapseAll;
end;

procedure TForm1.mnuExitClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.InspectObject(Sender: TObject);
begin
  ObjectManager.TheObject := Sender;
  if Assigned(ObjectManager.TheObject) then begin
    LabelObject.Caption := ObjectManager.ObjectTypeName + ' ' + ObjectManager.ObjectName;
    ObjectInspector.NewObject;
  end
  else
    ClearInspector;
end;

procedure TForm1.OnEnumProperties(Sender: TObject; Index: Integer;
  out Info: PGsvObjectInspectorPropertyInfo);
begin
  Info := ObjectManager.PropertyInfo(Index);
end;

procedure TForm1.OnGetStringValue(Sender: TObject;
  Info: PGsvObjectInspectorPropertyInfo; out Value: String);
begin
  try
    Value := ObjectManager.GetStringValue(Info);
  except
    on E: Exception do
      StatusMessage('Error: ' + E.Message);
  end;
end;

procedure TForm1.OnSetStringValue(Sender: TObject;
  Info: PGsvObjectInspectorPropertyInfo; const Value: String);
begin
  try
    StatusClear;
    ObjectInspector.ValidateStringValue(Value);
    ObjectManager.SetStringValue(Info, Value);
  except
    on E: Exception do
      StatusMessage('Error: ' + E.Message);
  end;
end;

procedure TForm1.OnGetIntegerValue(Sender: TObject;
  Info: PGsvObjectInspectorPropertyInfo; out Value: LongInt);
begin
  try
    Value := ObjectManager.GetIntegerValue(Info);
  except
    on E: Exception do
      StatusMessage('Error: ' + E.Message);
  end;
end;

procedure TForm1.OnSetIntegerValue(Sender: TObject;
  Info: PGsvObjectInspectorPropertyInfo; const Value: LongInt);
begin
  try
    StatusClear;
    ObjectManager.SetIntegerValue(Info, Value);
  except
    on E: Exception do
      StatusMessage('Error: ' + E.Message);
  end;
end;

procedure TForm1.OnFillList(Sender: TObject;
  Info: PGsvObjectInspectorPropertyInfo; List: TStrings);
begin
  try
    ObjectManager.FillList(Info, List);
  except
    on E: Exception do
      StatusMessage('Error: ' + E.Message);
  end;
end;

procedure TForm1.OnShowDialog(Inspector: TComponent;
  Info: PGsvObjectInspectorPropertyInfo; const EditRect: TRect);
begin
  try
    StatusClear;
    ObjectManager.ShowDialog(Inspector, Info, EditRect);
  except
    on E: Exception do
      StatusMessage('Error: ' + E.Message);
  end;
end;

procedure TForm1.OnHelp(Sender: TObject; Info: PGsvObjectInspectorPropertyInfo);
begin
  if Assigned(Info) then
    with Info^ do
      StatusMessage(Format('%s:  : %d', [Caption, Help]));
end;

procedure TForm1.OnHint(Sender: TObject; Info: PGsvObjectInspectorPropertyInfo);
begin
  if Assigned(Info) then begin
    with Info^ do begin
      if Hint <> '' then
        StatusMessage(Format('%s: %s', [Caption, Hint]))
      else
        StatusMessage(Caption);
    end;
  end;
end;

procedure TForm1.OnGetCaption(Sender: TObject;
  Info: PGsvObjectInspectorPropertyInfo; var aCaption: string);
begin
  aCaption := AnsiLower(PChar(aCaption));
end;

procedure TForm1.ButtonRectClick(Sender: TObject);
var
  p: TObject;
begin
  p := Proxy;
  Proxy := TRect_Proxy.Create(@FRect);
  InspectObject(Proxy);
  p.Free;
end;

procedure TForm1.TimerInspectorTimer(Sender: TObject);
begin
  ObjectInspector.SmartInvalidate;
end;

procedure TForm1.TimerDemoTimer(Sender: TObject);
begin
  if Label1.Width > 100 then
    Label1.Width := 50
  else
    Label1.Width := Label1.Width + 1;
end;

procedure TForm1.CheckBoxAutoUpdateClick(Sender: TObject);
var
  en: Boolean;
begin
  en := CheckBoxAutoUpdate.Checked;
  TimerInspector.Enabled := en;
  TimerDemo.Enabled      := en;
end;

procedure TForm1.ButtonDemoClick(Sender: TObject);
begin
  InspectObject(DemoObject);
end;

procedure TForm1.StatusClear;
begin
  StatusMessage('');
end;

procedure TForm1.StatusMessage(const S: String);
begin
  StatusBar.SimpleText := S;
end;

procedure TForm1.ClearInspector;
begin
  ObjectInspector.Clear;
  LabelObject.Caption := '';
  FreeAndNil(Proxy);
end;

end.
