unit UnitInfo;

interface

uses
  Classes, Types,
  GsvObjectInspectorTypes;

type
  TGsvBounds_INFO = class(TGsvObjectInspectorTypeInfo)
  public
    class function  TypeInfo: PGsvObjectInspectorPropertyInfo; override;
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

  TGsvCursor_INFO = class(TGsvObjectInspectorTypeListInfo)
  protected
    class function  ListEnumItems(Index: Integer):
                    PGsvObjectInspectorListItem; override;
  public
    class function  TypeInfo: PGsvObjectInspectorPropertyInfo; override;
  end;

  TGsvColor16_INFO = class(TGsvObjectInspectorTypeListInfo)
  protected
    class function  ListEnumItems(Index: Integer):
                    PGsvObjectInspectorListItem; override;
  public
    class function  TypeInfo: PGsvObjectInspectorPropertyInfo; override;
  end;

  TGsvColorRGB_INFO = class(TGsvObjectInspectorTypeColorRGBInfo)
  public
    class function  TypeInfo: PGsvObjectInspectorPropertyInfo; override;
  end;

  TFontStyles_INFO = class(TGsvObjectInspectorTypeSetInfo)
  public
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

  TFont_INFO = class(TGsvObjectInspectorTypeFontInfo)
  public
    class function  TypeInfo: PGsvObjectInspectorPropertyInfo; override;
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

  TFontWithColor_INFO = class(TFont_INFO)
  public
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

  TButton_INFO = class(TGsvObjectInspectorTypeInfo)
  public
    class function  TypeName: String; override;
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

  TLabelHint_INFO = class(TGsvObjectInspectorTypeListInfo)
  protected
    class function  ListEnumItems(Index: Integer):
                    PGsvObjectInspectorListItem; override;
  public
    class function  TypeInfo: PGsvObjectInspectorPropertyInfo; override;
  end;

  TLabel_INFO = class(TGsvObjectInspectorTypeInfo)
  public
    class function  TypeName: String; override;
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

  {$M+}
  TRect_Proxy = class
  private
    FRect: PRect; //    

    function  GetLeft: Integer;
    function  GetTop: Integer;
    function  GetWidth: Integer;
    function  GetHeight: Integer;
    procedure SetLeft(const Value: Integer);
    procedure SetTop(const Value: Integer);
    procedure SetWidth(const Value: Integer);
    procedure SetHeight(const Value: Integer);

  public
    constructor Create(ARect: PRect);

  published
    property Left: Integer read GetLeft write SetLeft;
    property Top: Integer read GetTop write SetTop;
    property Width: Integer read GetWidth write SetWidth;
    property Height: Integer read GetHeight write SetHeight;
  end;
  {$M-}

  TRect_Proxy_INFO = class(TGsvObjectInspectorTypeInfo)
  public
    class function  ObjectName(AObject: TObject): String; override;
    class function  TypeName: String; override;
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

implementation

uses
  Controls, StdCtrls, Graphics, SysUtils, TypInfo;

{ TGsvBounds_INFO }

class function TGsvBounds_INFO.TypeInfo: PGsvObjectInspectorPropertyInfo;
const
  DSK: TGsvObjectInspectorPropertyInfo = (
    Caption: '  '; Kind: pkFolder; Help: 2; Hint: '     '
  );
begin
  Result := @DSK;
end;

class function TGsvBounds_INFO.ChildrenInfo(Index: Integer):
  PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..3] of TGsvObjectInspectorPropertyInfo = (
    ( Name: 'Left'; Caption: ' '; Kind: pkText ),
    ( Name: 'Top'; Caption: ' '; Kind: pkText ),
    ( Name: 'Width'; Caption: ''; Kind: pkText ),
    ( Name: 'Height'; Caption: ''; Kind: pkText )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TGsvCursor_INFO }

class function TGsvCursor_INFO.ListEnumItems(
  Index: Integer): PGsvObjectInspectorListItem;
const
  DSK: array[0..2] of TGsvObjectInspectorListItem = (
    ( Name: ''; Data: crDefault),
    ( Name: ''; Data: crCross),
    ( Name: ''; Data: crHandPoint)
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

class function TGsvCursor_INFO.TypeInfo: PGsvObjectInspectorPropertyInfo;
const
  DSK: TGsvObjectInspectorPropertyInfo = (
    Caption: ''; Kind: pkDropDownList; Help: 4; Hint: '  '
  );
begin
  Result := @DSK;
end;

{ TGsvColor16_INFO }

class function TGsvColor16_INFO.ListEnumItems(
  Index: Integer): PGsvObjectInspectorListItem;
const
  DSK: array[0..15] of TGsvObjectInspectorListItem = (
    ( Name: '';       Data: clBlack ),
    ( Name: '';   Data: clMaroon ),
    ( Name: ''; Data: clGreen ),
    ( Name: '';    Data: clOlive ),
    ( Name: '';   Data: clNavy ),
    ( Name: '';    Data: clPurple ),
    ( Name: '';    Data: clTeal ),
    ( Name: '';   Data: clGray ),
    ( Name: '';  Data: clSilver ),
    ( Name: '';      Data: clRed ),
    ( Name: '';     Data: clLime ),
    ( Name: '';       Data: clYellow ),
    ( Name: '';        Data: clBlue ),
    ( Name: '';      Data: clFuchsia ),
    ( Name: '';      Data: clAqua ),
    ( Name: '';        Data: clWhite )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

class function TGsvColor16_INFO.TypeInfo: PGsvObjectInspectorPropertyInfo;
const
  DSK: TGsvObjectInspectorPropertyInfo = (
    Caption: ''; Kind: pkDropDownList; Help: 4; Hint: '   '
  );
begin
  Result := @DSK;
end;

{ TGsvColorRGB_INFO }

class function TGsvColorRGB_INFO.TypeInfo: PGsvObjectInspectorPropertyInfo;
const
  DSK: TGsvObjectInspectorPropertyInfo = (
    Caption: ''; Kind: pkColorRgb
  );
begin
  Result := @DSK;
end;

{ TFontStyles_INFO }

class function TFontStyles_INFO.ChildrenInfo(
  Index: Integer): PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..2] of TGsvObjectInspectorPropertyInfo = (
    ( Name: 'Style'; Caption: ''; Kind: pkBoolean; Tag: Ord(fsBold) ),
    ( Name: 'Style'; Caption: ''; Kind: pkBoolean; Tag: Ord(fsItalic) ),
    ( Name: 'Style'; Caption: ''; Kind: pkBoolean; Tag: Ord(fsUnderline) )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TFont_INFO }

class function TFont_INFO.TypeInfo: PGsvObjectInspectorPropertyInfo;
const
  DSK: TGsvObjectInspectorPropertyInfo = (
    Caption: ''; Kind: pkDialog; Help: 3; Hint: '  -    '
  );
begin
  Result := @DSK;
end;

class function TFont_INFO.ChildrenInfo(Index: Integer):
  PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..2] of TGsvObjectInspectorPropertyInfo = (
    ( Name: 'Name'; Caption: ''; Kind: pkText; Hint: ' ' ),
    ( Name: 'Size'; Caption: ''; Kind: pkText; Hint: '  '),
    ( Name: 'Style'; Caption: ''; Kind: pkSet; NestedClass: TFontStyles_INFO)
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TFontWithColor_INFO }

class function TFontWithColor_INFO.ChildrenInfo(
  Index: Integer): PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..3] of TGsvObjectInspectorPropertyInfo = (
    ( Name: 'Name'; Caption: ''; Kind: pkText; Hint: ' ' ),
    ( Name: 'Size'; Caption: ''; Kind: pkText; Hint: '  ' ),
    ( Name: 'Style'; Caption: ''; Kind: pkSet; NestedClass: TFontStyles_INFO ),
    ( Name: 'Color'; Caption: ''; Kind: pkColor; NestedClass: TGsvColor16_INFO )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;


{ TButton_INFO }

class function TButton_INFO.TypeName: String;
begin
  Result := '';
end;

class function TButton_INFO.ChildrenInfo(
  Index: Integer): PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..5] of TGsvObjectInspectorPropertyInfo = (
    ( Name: 'Caption'; Caption: ''; Kind: pkImmediateText; Help: 1; Hint: '  ' ),
    ( Name: 'Name'; Caption: ''; Kind: pkReadOnlyText; Help: 6; Hint: '  ' ),
    ( NestedClass: TGsvBounds_INFO ),
    ( Name: 'Font'; NestedType: 'TFont' ),
    ( Name: 'Cursor'; NestedClass: TGsvCursor_INFO ),
    ( Name: 'Visible'; Caption: ''; Kind: pkBoolean )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TLabelHint_INFO }

class function TLabelHint_INFO.ListEnumItems(
  Index: Integer): PGsvObjectInspectorListItem;
const
  DSK: array[0..2] of TGsvObjectInspectorListItem = (
    ( Name: '  ' ),
    ( Name: ' 1' ),
    ( Name: ' 2' )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

class function TLabelHint_INFO.TypeInfo: PGsvObjectInspectorPropertyInfo;
const
  DSK: TGsvObjectInspectorPropertyInfo = (
    Caption: ''; Kind: pkTextList; Hint: '  '
  );
begin
  Result := @DSK;
end;

{ TLabel_INFO }

class function TLabel_INFO.TypeName: String;
begin
  Result := '';
end;

class function TLabel_INFO.ChildrenInfo(
  Index: Integer): PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..4] of TGsvObjectInspectorPropertyInfo = (
    ( Name: 'Caption'; Caption: ''; Kind: pkImmediateText; Help: 1 ),
    ( Name: 'Hint'; NestedClass: TLabelHint_INFO ),
    ( NestedClass: TGsvBounds_INFO ),
    ( Name: 'Font'; NestedType: 'TFontWithColor' ),
    ( Name: 'Color'; Caption: ' '; NestedClass: TGsvColorRGB_INFO )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TRect_Proxy }

constructor TRect_Proxy.Create(ARect: PRect);
begin
  Assert(Assigned(ARect));
  FRect := ARect;
end;

function TRect_Proxy.GetLeft: Integer;
begin
  result := FRect^.Left;
end;

function TRect_Proxy.GetTop: Integer;
begin
  result := FRect^.Top;
end;

function TRect_Proxy.GetWidth: Integer;
begin
  result := FRect^.Right - FRect^.Left;
end;

function TRect_Proxy.GetHeight: Integer;
begin
  result := FRect^.Bottom - FRect^.Top;
end;

procedure TRect_Proxy.SetLeft(const Value: Integer);
var
  w: Integer;
begin
  w           := Width;
  FRect^.Left := Value;
  Width       := w;
end;

procedure TRect_Proxy.SetTop(const Value: Integer);
var
  h: Integer;
begin
  h          := Height;
  FRect^.Top := Value;
  Height     := h;
end;

procedure TRect_Proxy.SetWidth(const Value: Integer);
begin
  FRect^.Right := FRect^.Left + Value;
end;

procedure TRect_Proxy.SetHeight(const Value: Integer);
begin
  FRect^.Bottom := FRect^.Top + Value;
end;

{ TRect_Proxy_INFO }

class function TRect_Proxy_INFO.ObjectName(AObject: TObject): String;
begin
  Result := 'Rect';
end;

class function TRect_Proxy_INFO.TypeName: String;
begin
  Result := ' ';
end;

class function TRect_Proxy_INFO.ChildrenInfo(
  Index: Integer): PGsvObjectInspectorPropertyInfo;
const
  DSK: TGsvObjectInspectorPropertyInfo = (
    NestedClass: TGsvBounds_INFO
  );
begin
  if Index = 0 then Result := @DSK
  else              Result := nil;
end;

initialization
  GsvRegisterTypesInfo([TGsvBounds_INFO, TGsvCursor_INFO, TFontStyles_INFO,
    TFont_INFO, TFontWithColor_INFO, TButton_INFO, TLabel_INFO,
    TRect_Proxy_INFO]);

end.
