unit UnitDemoObj;

interface

uses
  Classes, Types, Dialogs, SysUtils, Graphics,
  GsvObjectInspectorTypes;

type
  TDemoEnum = (deItem0, deItem1, deItem2);
  TDemoSet  = set of TDemoEnum;

  TDemoObject = class(TPersistent)
  public
    constructor Create;
    destructor  Destroy; override;

  private
    FText:              String;
    FDropDownListIndex: Integer;
    FDialogText:        String;
    FReadOnlyText:      String;
    FBoolean:           Boolean;
    FImmediateText:     String;
    FTextListItem:      String;
    FSet:               TDemoSet;
    FColor:             TColor;
    FColorRGB:          TColor;
    FFloat:             Double;
    FTextDialogText:    String;
    FFontObject:        TFont;

    FPhone:             String;
    FCountry:           String;
    FFloatPM0:          Double;

  published
    property Text: String read FText write FText;
    property DropDownListIndex: Integer read FDropDownListIndex
             write FDropDownListIndex;
    property DialogText: String read FDialogText write FDialogText;
    property ReadOnlyText: String read FReadOnlyText;
    property TheBoolean: Boolean read FBoolean write FBoolean;
    property ImmediateText: String read FImmediateText write FImmediateText;
    property TextListItem: String read FTextListItem write FTextListItem;
    property TheSet: TDemoSet read FSet write FSet;
    property Color: TColor read FColor write FColor;
    property ColorRGB: TColor read FColorRGB write FColorRGB;
    property TheFloat: Double read FFloat write FFloat;
    property TextDialogText: String read FTextDialogText write FTextDialogText;
    property FontObject: TFont read FFontObject write FFontObject;

    property Phone: String read FPhone write FPhone;
    property Country: String read FCountry write FCountry;
    property FloatPM0: Double read FFloatPM0 write FFloatPM0;
  end;

  TDemoDropDownList_INFO = class(TGsvObjectInspectorTypeListInfo)
  protected
    class function  ListEnumItems(Index: Integer):
                    PGsvObjectInspectorListItem; override;
  end;

  TDemoDialog_INFO = class(TGsvObjectInspectorTypeInfo)
  public
    class procedure ShowDialog(Inspector: TComponent;
                    Info: PGsvObjectInspectorPropertyInfo;
                    const EditRect: TRect); override;
    class function  ObjectToString(const Value: TObject): String; override;
  end;

  TDemoTextList_INFO = class(TGsvObjectInspectorTypeListInfo)
  protected
    class function  ListEnumItems(Index: Integer):
                    PGsvObjectInspectorListItem; override;
  end;

  TDemoSet_INFO = class(TGsvObjectInspectorTypeSetInfo)
  public
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

  TDemoColor_INFO = class(TGsvObjectInspectorTypeListInfo)
  protected
    class function  ListEnumItems(Index: Integer):
                    PGsvObjectInspectorListItem; override;
  end;

  TDemoColorRGB_INFO = class(TGsvObjectInspectorTypeColorRGBInfo)
  end;

  TDemoTextDialog_INFO = class(TGsvObjectInspectorTypeInfo)
  public
    class procedure ShowDialog(Inspector: TComponent;
                    Info: PGsvObjectInspectorPropertyInfo;
                    const EditRect: TRect); override;
    class function  ObjectToString(const Value: TObject): String; override;
  end;

  TDemoFontObject_INFO = class(TGsvObjectInspectorTypeFontInfo)
  public
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

  TDemoVariantsText_INFO = class(TGsvObjectInspectorTypeInfo)
  public
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

  TDemoVariantsFloat_INFO = class(TGsvObjectInspectorTypeInfo)
  public
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

  TDemoVariants_INFO = class(TGsvObjectInspectorTypeInfo)
  public
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

  TDemoObject_INFO = class(TGsvObjectInspectorTypeInfo)
  public
    class function  ObjectName(AObject: TObject): String; override;
    class function  TypeName: String; override;
    class function  ChildrenInfo(Index: Integer):
                    PGsvObjectInspectorPropertyInfo; override;
  end;

var
  ObjectManager: TGsvObjectInspectorObjectInfo;

implementation

{ TDemoObject }

constructor TDemoObject.Create;
begin
  inherited Create;
  FText              := 'Simple string';
  FDropDownListIndex := 1;
  FDialogText        := 'Dialog string';
  FReadOnlyText      := 'ReadOnly string';
  FBoolean           := True;
  FImmediateText     := 'Immediate string';
  FTextListItem      := 'Item2';
  FSet               := [deItem1, deItem2];
  FColor             := clBlue;
  FColorRGB          := TColor($00ACDFFE);
  FFloat             := 3.1415;
  FTextDialogText    := 'TextDialog string';
  FFontObject        := TFont.Create;
  with FFontObject do begin
    Name := 'Times New Roman';
    Size := 20;
  end;

  FPhone             := '(7890) 12-34-56';
  FCountry           := 'RU';
  FFloatPM0          := -368987.896535;
end;

destructor TDemoObject.Destroy;
begin
  FFontObject.Free;
  inherited;
end;

{ TDemoDropDownList_INFO }

class function TDemoDropDownList_INFO.ListEnumItems(
  Index: Integer): PGsvObjectInspectorListItem;
const
  DSK: array[0..2] of TGsvObjectInspectorListItem = (
    ( Name: 'Item0'; Data: 0),
    ( Name: 'Item1'; Data: 1),
    ( Name: 'Item2'; Data: 2)
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TDemoDialog_INFO }

class procedure TDemoDialog_INFO.ShowDialog(Inspector: TComponent;
  Info: PGsvObjectInspectorPropertyInfo; const EditRect: TRect);
var
  obj: TDemoObject;
  s:   String;
begin
  if not Assigned(Info) then
    Exit;
  if not Assigned(Info^.NestedObject) then
    Exit;
  if not (Info^.NestedObject is TDemoObject) then
    Exit;
  obj := TDemoObject(Info^.NestedObject);
  s := InputBox('Input dialog string', 'String:', obj.DialogText);
  obj.DialogText := s;
end;

class function TDemoDialog_INFO.ObjectToString(
  const Value: TObject): String;
begin
  Result := '';
  if Assigned(Value) then
    if Value is TDemoObject then
      Result := TDemoObject(Value).DialogText;
end;

{ TDemoTextList_INFO }

var
  TDemoTextList_DSK: TGsvObjectInspectorListItem;

class function TDemoTextList_INFO.ListEnumItems(
  Index: Integer): PGsvObjectInspectorListItem;
begin
  if Index <= 20 then begin
    TDemoTextList_DSK.Name := Format('Item%d', [Index]);
    TDemoTextList_DSK.Data := 0;
    Result := @TDemoTextList_DSK;
  end
  else
    Result := nil;
end;

{ TDemoSet_INFO }

class function TDemoSet_INFO.ChildrenInfo(
  Index: Integer): PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..2] of TGsvObjectInspectorPropertyInfo = (
    ( Name: 'TheSet'; Caption: 'Item0'; Kind: pkBoolean; Tag: Ord(deItem0) ),
    ( Name: 'TheSet'; Caption: 'Item1'; Kind: pkBoolean; Tag: Ord(deItem1) ),
    ( Name: 'TheSet'; Caption: 'Item2'; Kind: pkBoolean; Tag: Ord(deItem2) )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TDemoColor_INFO }

class function TDemoColor_INFO.ListEnumItems(
  Index: Integer): PGsvObjectInspectorListItem;
const
  DSK: array[0..8] of TGsvObjectInspectorListItem = (
    ( Name: '';       Data: clBlack ),
    ( Name: '';  Data: clSilver ),
    ( Name: '';      Data: clRed ),
    ( Name: '';     Data: clLime ),
    ( Name: '';       Data: clYellow ),
    ( Name: '';        Data: clBlue ),
    ( Name: '';      Data: clFuchsia ),
    ( Name: '';      Data: clAqua ),
    ( Name: '';        Data: clWhite )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TDemoTextDialog_INFO }

class procedure TDemoTextDialog_INFO.ShowDialog(Inspector: TComponent;
  Info: PGsvObjectInspectorPropertyInfo; const EditRect: TRect);
var
  obj: TDemoObject;
  s:   String;
begin
  if not Assigned(Info) then
    Exit;
  if not Assigned(Info^.NestedObject) then
    Exit;
  if not (Info^.NestedObject is TDemoObject) then
    Exit;
  obj := TDemoObject(Info^.NestedObject);
  s := InputBox('Input text dialog string', 'String:', obj.TextDialogText);
  obj.TextDialogText := s;
end;

class function TDemoTextDialog_INFO.ObjectToString(
  const Value: TObject): String;
begin
  Result := '';
  if Assigned(Value) then
    if Value is TDemoObject then
      Result := TDemoObject(Value).TextDialogText;
end;

{ TDemoFontObject_INFO }

class function TDemoFontObject_INFO.ChildrenInfo(
  Index: Integer): PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..1] of TGsvObjectInspectorPropertyInfo = (
    ( Name: 'Name'; Caption: ''; Kind: pkText; Hint: ' ' ),
    ( Name: 'Size'; Caption: ''; Kind: pkText; Hint: '  ')
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TDemoVariantsText_INFO }

class function TDemoVariantsText_INFO.ChildrenInfo(
  Index: Integer): PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..1] of TGsvObjectInspectorPropertyInfo = (
    ( Name: 'Phone'; Caption: 'Phone'; Kind: pkText; Hint: ' '; EditMask: '(0000) 00-00-00;1' ),
    ( Name: 'Country'; Caption: 'Country'; Kind: pkText; Hint: '   (  )'; EditMask: '>LL;1' )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TDemoVariantsFloat_INFO }

class function TDemoVariantsFloat_INFO.ChildrenInfo(
  Index: Integer): PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..0] of TGsvObjectInspectorPropertyInfo = (
    ( Name: 'FloatPM0'; Caption: 'Float (+,-,0)'; Kind: pkFloat; Hint: '     +, -  0'; FloatFormat: '#,##0.00000;-#,##0.00;0.0' )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TDemoVariants_INFO }

class function TDemoVariants_INFO.ChildrenInfo(
  Index: Integer): PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..3] of TGsvObjectInspectorPropertyInfo = (
    ( Name: 'FontObject'; Caption: 'Font object (dialog)'; Kind: pkDialog; NestedClass: TDemoFontObject_INFO; Hint: '  pkDialog,     - ' ),
    ( Name: 'FontObject'; Caption: 'Font object (folder)'; Kind: pkFolder; NestedClass: TDemoFontObject_INFO; Hint: '  pkFolder,     - ' ),
    ( Caption: 'pkText (masked)'; Kind: pkFolder; NestedClass: TDemoVariantsText_INFO ),
    ( Caption: 'pkFloat (format)'; Kind: pkFolder; NestedClass: TDemoVariantsFloat_INFO )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

{ TDemoObject_INFO }

class function TDemoObject_INFO.ObjectName(AObject: TObject): String;
begin
  Result := 'DemoObject';
end;

class function TDemoObject_INFO.TypeName: String;
begin
  Result := '-';
end;

class function TDemoObject_INFO.ChildrenInfo(
  Index: Integer): PGsvObjectInspectorPropertyInfo;
const
  DSK: array[0..13] of TGsvObjectInspectorPropertyInfo = (
    ( Caption: ' '; Kind: pkFolder ),
    ( Name: 'Text'; Caption: 'pkText'; Kind: pkText; Hint: '   pkText' ),
    ( Name: 'DropDownListIndex'; Caption: 'pkDropDownList'; Kind: pkDropDownList; NestedClass: TDemoDropDownList_INFO; Hint: '   pkDropDownList' ),
    ( Name: 'DialogText'; Caption: 'pkDialog'; Kind: pkDialog; NestedClass: TDemoDialog_INFO; Hint: '   pkDialog -     ' ),
    ( Name: 'ReadOnlyText'; Caption: 'pkReadOnlyText'; Kind: pkReadOnlyText; Hint: '  pkReadOnlyText -   ' ),
    ( Name: 'TheBoolean'; Caption: 'pkBoolean'; Kind: pkBoolean; Hint: '   pkBoolean' ),
    ( Name: 'ImmediateText'; Caption: 'pkImmediateText'; Kind: pkImmediateText; Hint: '  pkImmediateText -   ' ),
    ( Name: 'TextListItem'; Caption: 'pkTextList'; Kind: pkTextList; NestedClass: TDemoTextList_INFO; Hint: '  pkTextList c     ' ),
    ( Name: 'TheSet'; Caption: 'pkSet'; Kind: pkSet; NestedClass: TDemoSet_INFO; Hint: '  pkSet' ),
    ( Name: 'Color'; Caption: 'pkColor'; Kind: pkColor; NestedClass: TDemoColor_INFO; Hint: '  pkColor' ),
    ( Name: 'ColorRGB'; Caption: 'pkColorRGB'; Kind: pkColorRGB; NestedClass: TDemoColorRGB_INFO; Hint: '  pkColorRGB' ),
    ( Name: 'TheFloat'; Caption: 'pkFloat'; Kind: pkFloat; Hint: '   pkFloat' ),
    ( Name: 'TextDialogText'; Caption: 'pkTextDialog'; Kind: pkTextDialog; NestedClass: TDemoTextDialog_INFO; Hint: '   pkTextDialog -       ' ),
    ( Caption: '   '; Kind: pkFolder; NestedClass: TDemoVariants_INFO )
  );
begin
  if Index <= High(DSK) then Result := @DSK[Index]
  else                       Result := nil;
end;

initialization
  GsvRegisterTypeInfo(TDemoObject_INFO);

end.
